/*********************************************************************************

Copyright (c) 2010, Vernier Software & Technology
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Vernier Software & Technology nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL VERNIER SOFTWARE & TECHNOLOGY BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

**********************************************************************************/
// GCharacters.h

#ifndef _GCHARACTERS_H_
#define _GCHARACTERS_H_

namespace GUTF8CharCode
{

const unsigned short kAmpersand = 0x26;

const unsigned short kNonBreakingSpace = 0xA0;
const unsigned short kCopyright = 0xA9;
const unsigned short kRegistered = 0xAE;
const unsigned short kDegree = 0xB0;
const unsigned short kPlusOrMinus = 0xB1;
const unsigned short kMu = 0xB5;
const unsigned short kBullet = 0xB7;
const unsigned short kOneFourth = 0xBC;
const unsigned short kOneHalf = 0xBD;
const unsigned short kThreeFourths = 0xBE;

const unsigned short kLowerCaseAlpha = 0x3B1;
const unsigned short kLowerCaseBeta = 0x3B2;
const unsigned short kLowerCaseTheta = 0x3B8;
const unsigned short kLowerCasePi = 0x3C0;

const unsigned short kUpperCaseDelta = 0x394;
const unsigned short kUpperCaseSigma = 0x3A3;
const unsigned short kUpperCaseOmega = 0x3A9;

const unsigned short kMathSum = 0x2211; // same as greek uppercase sigma?

const unsigned short kSqareRoot = 0x221A;
const unsigned short kIntegral = 0x222B;
const unsigned short kNotEqualTo = 0x2260;
const unsigned short kLessThanOrEqual = 0x2264;
const unsigned short kGreaterThanOrEqual = 0x2265;

const unsigned short kSuperScriptTwo = 0xB2;

} // end namespace GUTF8CharCode

#ifdef TARGET_OS_LINUX
// These character literals are readable on a Mac with any standard font.
const char kDeltaChar = '';
const char kCopyrightChar = '';
const char kBulletChar = '';
const char kDegreeChar = '';
const char kMuChar = '';
const char kPiChar = '';
const char kSumChar = '';
const char kOmegaChar = '';
const char kMathrootChar = '';
const char kNotEqualChar = '';
const char kPlusOrMinusChar = '';
const char kIntegralChar = '';
const char kOSNewlineChar = '\r';
const char kOSPathSeparatorChar = ':';
const char kAmpersandChar = '&';
const char kGreaterThanChar = '>';
const char kLessThanChar = '<';

const cppstring kOneQuarter = "1/4";
const cppstring kOneHalf = "1/2";
const cppstring kThreeQuarters = "3/4";
const cppstring kCapYAcute = "Y^";
const cppstring kLwYAcute = "y^";
const cppstring kCapSCaron = "S^";
const cppstring kLwSCaron = "s^";

const cppstring kSuperScriptTwo = "^2";

#define kOSNewlineString GSTD_S("\n")
#define kOSPathSeparatorString GSTD_S("/")

#endif // TARGET_OS_LINUX

#ifdef TARGET_OS_MAC
// These character literals are readable on a Mac with any standard font.
const char kDeltaChar = '';
const char kCopyrightChar = '';
const char kBulletChar = '';
const char kDegreeChar = '';
const char kMuChar = '';
const char kPiChar = '';
const char kSumChar = '';
const char kOmegaChar = '';
const char kMathrootChar = '';
const char kNotEqualChar = '';
const char kPlusOrMinusChar = '';
const char kIntegralChar = '';
const char kOSNewlineChar = '\r';
const char kOSPathSeparatorChar = ':';
const char kAmpersandChar = '&';
const char kGreaterThanChar = '>';
const char kLessThanChar = '<';

const cppstring kOneQuarter = "1/4";
const cppstring kOneHalf = "1/2";
const cppstring kThreeQuarters = "3/4";
const cppstring kCapYAcute = "Y^";
const cppstring kLwYAcute = "y^";
const cppstring kCapSCaron = "S^";
const cppstring kLwSCaron = "s^";

const cppstring kSuperScriptTwo = "^2";

#define kOSNewlineString GSTD_S("\r")
#define kOSPathSeparatorString GSTD_S(":")

#endif // TARGET_MAC_OS

#ifdef TARGET_OS_WIN
// Define windows special character equivalents here

const gchar kDeltaChar = GSTD_S('d');
const gchar kCopyrightChar = GSTD_S('');
const gchar kBulletChar = GSTD_S('');
const gchar kDegreeChar = GSTD_S('');
const gchar kMuChar = GSTD_S('');
const gchar kPiChar = GSTD_S('x');
const gchar kSumChar = GSTD_S('x');
const gchar kOmegaChar = GSTD_S('x');
const gchar kMathrootChar = GSTD_S('x');
const gchar kNotEqualChar = GSTD_S('x');
const gchar kPlusOrMinusChar = GSTD_S('');
const gchar kIntegralChar = GSTD_S('');
const gchar kOSNewlineChar = GSTD_S('\n'); // not CRLF, but it will work for text in dialogs and most edit-control situations
const gchar kOSPathSeparatorChar = GSTD_S('\\');

const gchar kAmpersandChar = '&';
const gchar kGreaterThanChar = GSTD_S('>');
const gchar kLessThanChar = GSTD_S('<');

const gchar kOneQuarter = GSTD_S('');
const gchar kOneHalf = GSTD_S('');
const gchar kThreeQuarters = GSTD_S('');
const gchar kCapYAcute = GSTD_S('');
const gchar kLwYAcute = GSTD_S('');
const gchar kCapSCaron = GSTD_S('');
const gchar kLwSCaron = GSTD_S('');
const gchar kSuperScriptTwo = GSTD_S('');

#define kOSNewlineString GSTD_S("\n")
#define kOSPathSeparatorString GSTD_S("\\")

#endif // TARGET_OS_WIN

#define kMacPathSeparatorString GSTD_S(":")
#define kWinPathSeparatorString GSTD_S("\\")

#endif // _GCHARACTERS_H_ 
